/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	PartSaveAs.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CFile.h"
#include "CApplication.h"

// Save the active part with the specified name

HRESULT PartSaveAs(CString fileName) 
{

	START_METHOD("PartSaveAs")

	HRESULT status = CONV_SUCCESS;
	IApplication *pdApplication = NULL;

	// Get the application
	status = GetProDESKTOPApplication(&pdApplication);
	CHECK_RETURN_STATUS(status)

	// get active design
	IDispatch *pActiveDoc = NULL;
	status = pdApplication->GetActiveDoc(&pActiveDoc);
	CHECK_RETURN_STATUS(status)

	IPartDocument *activePart = CAST(IPartDocument, pActiveDoc);
	activePart->Release();

	IGraphicDocument *activeGraphicDoc = CAST(IGraphicDocument, pActiveDoc);

	IPartOthers *part1 = CAST(IPartOthers, activePart);

	// save the part
	VARIANT_BOOL retval = FALSE;
	status = activeGraphicDoc->SaveAs(fileName.AllocSysString(), TRUE, &retval);
	CHECK_RETURN_STATUS(status)

	END_METHOD("PartSaveAs")
}
